/*
 * Decompiled with CFR 0.152.
 */
package cds.savot.pull;

import cds.savot.common.Markups;
import cds.savot.common.SavotStatistics;
import cds.savot.common.VOTableTag;
import cds.savot.model.MarkupComment;
import cds.savot.model.SavotBinary;
import cds.savot.model.SavotBinary2;
import cds.savot.model.SavotCoosys;
import cds.savot.model.SavotData;
import cds.savot.model.SavotDefinitions;
import cds.savot.model.SavotField;
import cds.savot.model.SavotFieldRef;
import cds.savot.model.SavotFits;
import cds.savot.model.SavotGroup;
import cds.savot.model.SavotInfo;
import cds.savot.model.SavotLink;
import cds.savot.model.SavotMax;
import cds.savot.model.SavotMin;
import cds.savot.model.SavotOption;
import cds.savot.model.SavotParam;
import cds.savot.model.SavotParamRef;
import cds.savot.model.SavotResource;
import cds.savot.model.SavotStream;
import cds.savot.model.SavotTD;
import cds.savot.model.SavotTR;
import cds.savot.model.SavotTable;
import cds.savot.model.SavotTableData;
import cds.savot.model.SavotVOTable;
import cds.savot.model.SavotValues;
import cds.savot.model.TDSet;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.xmlpull.v1.XmlPullParser;

public final class SavotPullEngine
implements Markups {
    private static final Logger logger = Logger.getLogger(SavotPullEngine.class.getName());
    private static final boolean doTrimValues = false;
    private static final boolean doLineInfo = false;
    private static final boolean doStats = false;
    public static final int FULL = 0;
    public static final int FULLREAD = 0;
    public static final int SEQUENTIAL = 1;
    public static final int RESOURCEREAD = 1;
    public static final int ROWREAD = 2;
    public static final int DEFAULT_STACK_CAPACITY = 4;
    private static final SavotTD EMPTY_TD = new SavotTD();
    private final SavotStatistics statistics;
    private XmlPullParser xmlParser = null;
    private InputStream inputStream = null;
    private Reader reader = null;
    private boolean debugMode = false;
    private SavotVOTable _currentVOTable = new SavotVOTable();
    private SavotResource _currentResource = new SavotResource();
    private SavotTR _currentTR = new SavotTR();
    private int resourceCounter = 0;
    private int tableCounter = 0;
    private int rowCounter = 0;
    private int dataCounter = 0;
    private final ArrayList<VOTableTag> fatherTags = new ArrayList(4);
    private final ArrayList<SavotResource> resourcestack = new ArrayList(4);
    private final ArrayList<SavotOption> optionstack = new ArrayList(4);
    private final ArrayList<SavotGroup> groupstack = new ArrayList(4);
    private int includedResource = 0;
    private int includedOption = 0;
    private int includedGroup = 0;
    private SavotTable currentTable = null;
    private SavotField currentField = null;
    private SavotFieldRef currentFieldRef = null;
    private SavotGroup currentGroup = null;
    private SavotParam currentParam = null;
    private SavotParamRef currentParamRef = null;
    private SavotData currentData = null;
    private SavotValues currentValues = null;
    private SavotTableData currentTableData = null;
    private String currentDescription = null;
    private SavotLink currentLink = null;
    private SavotInfo currentInfo = null;
    private SavotMin currentMin = null;
    private SavotMax currentMax = null;
    private SavotOption currentOption = null;
    private SavotCoosys currentCoosys = null;
    private SavotDefinitions currentDefinitions = null;
    private SavotBinary currentBinary = null;
    private SavotBinary2 currentBinary2 = null;
    private SavotFits currentFits = null;
    private SavotStream currentStream = null;
    private final Map<String, Object> idRefLinks = new HashMap<String, Object>(256);

    public SavotPullEngine(XmlPullParser parser, String file, int mode, boolean debug, SavotStatistics stats) {
        this.xmlParser = parser;
        this.statistics = stats;
        this.enableDebug(debug);
        try {
            boolean compressed = file.endsWith("gz");
            this.inputStream = this.getInputStream(new FileInputStream(file), compressed);
            parser.setInput(this.inputStream, "UTF-8");
            int parsingType = this.parseMode(mode);
            if (parsingType == 0) {
                this.parse(parsingType);
            }
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "Exception SavotPullEngine : ", ioe);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception SavotPullEngine : ", e);
        }
    }

    public SavotPullEngine(XmlPullParser parser, URL url, int mode, String enc, boolean debug, SavotStatistics stats) {
        this.xmlParser = parser;
        this.statistics = stats;
        this.enableDebug(debug);
        boolean compressed = url.getPath().endsWith("gz");
        try {
            this.inputStream = this.getInputStream(url.openStream(), compressed);
            parser.setInput(this.inputStream, enc);
            int parsingType = this.parseMode(mode);
            if (parsingType == 0) {
                this.parse(parsingType);
            }
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "Exception SavotPullEngine : ", ioe);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception SavotPullEngine : ", e);
        }
    }

    public SavotPullEngine(XmlPullParser parser, InputStream instream, int mode, String enc, boolean debug, SavotStatistics stats) {
        this.xmlParser = parser;
        this.statistics = stats;
        this.enableDebug(debug);
        try {
            this.inputStream = this.getInputStream(instream, false);
            parser.setInput(this.inputStream, enc);
            int parsingType = this.parseMode(mode);
            if (parsingType == 0) {
                this.parse(parsingType);
            }
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "Exception SavotPullEngine : ", ioe);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception SavotPullEngine : ", e);
        }
    }

    public SavotPullEngine(XmlPullParser parser, Reader reader, int mode, boolean debug, SavotStatistics stats) {
        this.xmlParser = parser;
        this.statistics = stats;
        this.enableDebug(debug);
        try {
            this.reader = reader;
            parser.setInput(reader);
            int parsingType = this.parseMode(mode);
            if (parsingType == 0) {
                this.parse(parsingType);
            }
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "Exception SavotPullEngine : ", ioe);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception SavotPullEngine : ", e);
        }
    }

    private int parseMode(int mode) {
        switch (mode) {
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    private InputStream getInputStream(InputStream instream, boolean compressed) throws IOException {
        int bufferSize = 8192;
        InputStream in = compressed ? new GZIPInputStream(instream, 8192) : instream;
        return in;
    }

    public void close() {
        if (this.xmlParser != null) {
            this.xmlParser = null;
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException ioe) {
                logger.log(Level.INFO, "Exception SavotPullEngine.close: ", ioe);
            }
            this.inputStream = null;
        }
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException ioe) {
                logger.log(Level.INFO, "Exception SavotPullEngine.close: ", ioe);
            }
            this.reader = null;
        }
    }

    public void reset() {
        this._currentVOTable = new SavotVOTable();
        this._currentResource = new SavotResource();
        this.rowCounter = 0;
        this.resourceCounter = 0;
        this.tableCounter = 0;
        this.dataCounter = 0;
        this.idRefLinks.clear();
        this.resourcestack.clear();
        this.optionstack.clear();
        this.groupstack.clear();
    }

    private SavotResource getResourceStack() {
        return this.resourcestack.remove(this.resourcestack.size() - 1);
    }

    private void putResourceStack(SavotResource resource) {
        this.resourcestack.add(resource);
    }

    private SavotOption getOptionStack() {
        return this.optionstack.remove(this.optionstack.size() - 1);
    }

    private void putOptionStack(SavotOption option) {
        this.optionstack.add(option);
    }

    private SavotGroup getGroupStack() {
        return this.groupstack.remove(this.groupstack.size() - 1);
    }

    private void putGroupStack(SavotGroup group) {
        this.groupstack.add(group);
    }

    private VOTableTag lastFather() {
        int size = this.fatherTags.size();
        if (size == 0) {
            return VOTableTag.UNDEFINED;
        }
        return this.fatherTags.get(size - 1);
    }

    public void parse(int parsingType) throws IOException, Exception {
        XmlPullParser parser = this.xmlParser;
        if (parser == null) {
            return;
        }
        if (parsingType != 2 && parsingType != 1) {
            this.includedResource = 0;
            this.includedOption = 0;
            this.includedGroup = 0;
            this.currentTable = new SavotTable();
            this.currentField = new SavotField();
            this.currentFieldRef = new SavotFieldRef();
            this.currentGroup = new SavotGroup();
            this.currentParam = new SavotParam();
            this.currentParamRef = new SavotParamRef();
            this.currentData = new SavotData();
            this.currentValues = new SavotValues();
            this.currentTableData = new SavotTableData();
            this.currentDescription = "";
            this.currentLink = new SavotLink();
            this.currentInfo = new SavotInfo();
            this.currentMin = new SavotMin();
            this.currentMax = new SavotMax();
            this.currentOption = new SavotOption();
            this.currentCoosys = new SavotCoosys();
            this.currentDefinitions = new SavotDefinitions();
            this.currentBinary = new SavotBinary();
            this.currentBinary2 = new SavotBinary2();
            this.currentFits = new SavotFits();
            this.currentStream = new SavotStream();
        }
        String operation = "UNDEFINED";
        Enum tag = null;
        int rowCount = this.rowCounter;
        int dataCount = this.dataCounter;
        try {
            boolean trace = this.debugMode;
            SavotStatistics stats = this.statistics;
            SavotTD emptyTD = EMPTY_TD;
            ArrayList<VOTableTag> father = this.fatherTags;
            boolean resourceComplete = false;
            boolean TRComplete = false;
            SavotTR currentTR = this._currentTR;
            TDSet tdSet = null;
            SavotTD currentTD = null;
            Enum currentMarkup = VOTableTag.UNDEFINED;
            if (currentTR != null) {
                currentTR.clear();
                tdSet = currentTR.getTDs();
            }
            int eventType = parser.getEventType();
            while (eventType != 1) {
                String name;
                block1 : switch (eventType) {
                    case 2: {
                        operation = "START_TAG";
                        name = parser.getName();
                        if (name == null) break;
                        if (trace) {
                            System.err.println("Name ---> " + name);
                        }
                        if (tag == null) {
                            tag = this.withNamespace(name) ? VOTableTag.parseTag(name.split(":")[1]) : VOTableTag.parseTag(name);
                        }
                        if (trace) {
                            System.err.println(tag + " begin");
                        }
                        switch (1.$SwitchMap$cds$savot$common$VOTableTag[tag.ordinal()]) {
                            case 1: {
                                currentTD = null;
                                break;
                            }
                            case 2: {
                                stats.iTDLocalReset();
                                if (currentTR != null) break;
                                currentTR = new SavotTR();
                                tdSet = currentTR.getTDs();
                                break;
                            }
                            case 3: {
                                break;
                            }
                            case 4: {
                                String attrName;
                                String attrValue;
                                int i;
                                int counter = parser.getAttributeCount();
                                if (counter == 0) break;
                                for (i = 0; i < counter; ++i) {
                                    attrValue = parser.getAttributeValue(i);
                                    if (attrValue.length() == 0) continue;
                                    attrName = parser.getAttributeName(i);
                                    if (attrName.equalsIgnoreCase("version")) {
                                        this._currentVOTable.setVersion(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("xmlns:xsi")) {
                                        this._currentVOTable.setXmlnsxsi(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("xsi:noNamespaceSchemaLocation")) {
                                        this._currentVOTable.setXsinoschema(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("xsi:schemaLocation")) {
                                        this._currentVOTable.setXsischema(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("xmlns")) {
                                        this._currentVOTable.setXmlns(attrValue);
                                        continue;
                                    }
                                    if (!attrName.equalsIgnoreCase("id")) continue;
                                    this._currentVOTable.setId(attrValue);
                                    this.idRefLinks.put(attrValue, this._currentVOTable);
                                }
                                break;
                            }
                            case 5: {
                                String attrName;
                                String attrValue;
                                int i;
                                stats.iResourcesInc();
                                if (this.includedResource > 0) {
                                    this.putResourceStack(this._currentResource);
                                    if (trace) {
                                        System.err.println("RESOURCE - included");
                                    }
                                } else if (trace) {
                                    System.err.println("RESOURCE - not included");
                                }
                                ++this.includedResource;
                                ++this.resourceCounter;
                                if (parsingType == 0 || this._currentResource == null || parsingType == 2) {
                                    this._currentResource = new SavotResource();
                                } else {
                                    this._currentResource.init();
                                }
                                this._currentResource.setType("");
                                int counter = parser.getAttributeCount();
                                if (counter == 0) break;
                                for (i = 0; i < counter; ++i) {
                                    attrValue = parser.getAttributeValue(i);
                                    if (attrValue.length() == 0) continue;
                                    attrName = parser.getAttributeName(i);
                                    if (attrName.equalsIgnoreCase("name")) {
                                        this._currentResource.setName(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("type")) {
                                        this._currentResource.setType(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("utype")) {
                                        this._currentResource.setUtype(attrValue);
                                        continue;
                                    }
                                    if (!attrName.equalsIgnoreCase("id")) continue;
                                    this._currentResource.setId(attrValue);
                                    if (parsingType != 0) continue;
                                    this.idRefLinks.put(attrValue, this._currentResource);
                                }
                                break;
                            }
                            case 6: {
                                String attrName;
                                String attrValue;
                                int i;
                                stats.iTablesInc();
                                this.currentTable = new SavotTable();
                                ++this.tableCounter;
                                int counter = parser.getAttributeCount();
                                if (counter == 0) break;
                                for (i = 0; i < counter; ++i) {
                                    attrValue = parser.getAttributeValue(i);
                                    if (attrValue.length() == 0) continue;
                                    attrName = parser.getAttributeName(i);
                                    if (attrName.equalsIgnoreCase("name")) {
                                        this.currentTable.setName(attrValue);
                                        if (!trace) continue;
                                        System.err.println("TABLE name " + this.currentTable.getName());
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("ucd")) {
                                        this.currentTable.setUcd(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("utype")) {
                                        this.currentTable.setUtype(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("ref")) {
                                        this.currentTable.setRef(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("nrows")) {
                                        this.currentTable.setNrows(attrValue);
                                        continue;
                                    }
                                    if (!attrName.equalsIgnoreCase("id")) continue;
                                    this.currentTable.setId(attrValue);
                                    if (parsingType != 0) continue;
                                    this.idRefLinks.put(attrValue, this.currentTable);
                                    if (!trace) continue;
                                    System.err.println(attrValue);
                                }
                                break;
                            }
                            case 7: {
                                String attrName;
                                String attrValue;
                                int i;
                                this.currentField = new SavotField();
                                int counter = parser.getAttributeCount();
                                if (counter != 0) {
                                    for (i = 0; i < counter; ++i) {
                                        attrValue = parser.getAttributeValue(i);
                                        if (attrValue.length() == 0) continue;
                                        attrName = parser.getAttributeName(i);
                                        if (attrName.equalsIgnoreCase("unit")) {
                                            this.currentField.setUnit(attrValue);
                                            continue;
                                        }
                                        if (attrName.equalsIgnoreCase("datatype")) {
                                            this.currentField.setDataType(attrValue);
                                            continue;
                                        }
                                        if (attrName.equalsIgnoreCase("precision")) {
                                            this.currentField.setPrecision(attrValue);
                                            continue;
                                        }
                                        if (attrName.equalsIgnoreCase("width")) {
                                            this.currentField.setWidth(attrValue);
                                            continue;
                                        }
                                        if (attrName.equalsIgnoreCase("ref")) {
                                            this.currentField.setRef(attrValue);
                                            continue;
                                        }
                                        if (attrName.equalsIgnoreCase("name")) {
                                            this.currentField.setName(attrValue);
                                            continue;
                                        }
                                        if (attrName.equalsIgnoreCase("ucd")) {
                                            this.currentField.setUcd(attrValue);
                                            continue;
                                        }
                                        if (attrName.equalsIgnoreCase("arraysize")) {
                                            this.currentField.setArraySize(attrValue);
                                            continue;
                                        }
                                        if (attrName.equalsIgnoreCase("type")) {
                                            this.currentField.setType(attrValue);
                                            continue;
                                        }
                                        if (attrName.equalsIgnoreCase("utype")) {
                                            this.currentField.setUtype(attrValue);
                                            continue;
                                        }
                                        if (!attrName.equalsIgnoreCase("id")) continue;
                                        this.currentField.setId(attrValue);
                                        this.idRefLinks.put(attrValue, this.currentField);
                                    }
                                }
                                if (!trace) break;
                                System.err.println("on vient de remplir un FIELD ---> " + this.currentField.getName());
                                break;
                            }
                            case 8: {
                                String attrName;
                                String attrValue;
                                int i;
                                this.currentFieldRef = new SavotFieldRef();
                                int counter = parser.getAttributeCount();
                                if (counter == 0) break;
                                for (i = 0; i < counter; ++i) {
                                    attrValue = parser.getAttributeValue(i);
                                    if (attrValue.length() == 0) continue;
                                    attrName = parser.getAttributeName(i);
                                    if (attrName.equalsIgnoreCase("ref")) {
                                        this.currentFieldRef.setRef(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("ucd")) {
                                        this.currentFieldRef.setUcd(attrValue);
                                        continue;
                                    }
                                    if (!attrName.equalsIgnoreCase("utype")) continue;
                                    this.currentFieldRef.setUtype(attrValue);
                                }
                                break;
                            }
                            case 9: {
                                String attrName;
                                String attrValue;
                                int i;
                                this.currentValues = new SavotValues();
                                int counter = parser.getAttributeCount();
                                if (counter == 0) break;
                                for (i = 0; i < counter; ++i) {
                                    attrValue = parser.getAttributeValue(i);
                                    if (attrValue.length() == 0) continue;
                                    attrName = parser.getAttributeName(i);
                                    if (attrName.equalsIgnoreCase("type")) {
                                        this.currentValues.setType(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("null")) {
                                        this.currentValues.setNull(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("invalid")) {
                                        this.currentValues.setInvalid(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("ref")) {
                                        this.currentValues.setRef(attrValue);
                                        continue;
                                    }
                                    if (!attrName.equalsIgnoreCase("id")) continue;
                                    this.currentValues.setId(attrValue);
                                    this.idRefLinks.put(attrValue, this.currentValues);
                                }
                                break;
                            }
                            case 10: {
                                String attrName;
                                String attrValue;
                                int i;
                                this.currentStream = new SavotStream();
                                int counter = parser.getAttributeCount();
                                if (counter == 0) break;
                                for (i = 0; i < counter; ++i) {
                                    attrValue = parser.getAttributeValue(i);
                                    if (attrValue.length() == 0) continue;
                                    attrName = parser.getAttributeName(i);
                                    if (attrName.equalsIgnoreCase("type")) {
                                        this.currentStream.setType(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("href")) {
                                        this.currentStream.setHref(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("actuate")) {
                                        this.currentStream.setActuate(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("encoding")) {
                                        this.currentStream.setEncoding(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("expires")) {
                                        this.currentStream.setExpires(attrValue);
                                        continue;
                                    }
                                    if (!attrName.equalsIgnoreCase("rights")) continue;
                                    this.currentStream.setRights(attrValue);
                                }
                                break;
                            }
                            case 11: {
                                this.currentData = new SavotData();
                                break;
                            }
                            case 12: {
                                this.currentBinary = new SavotBinary();
                                break;
                            }
                            case 13: {
                                this.currentBinary2 = new SavotBinary2();
                                break;
                            }
                            case 14: {
                                String attrName;
                                String attrValue;
                                int i;
                                this.currentFits = new SavotFits();
                                int counter = parser.getAttributeCount();
                                if (counter == 0) break;
                                for (i = 0; i < counter; ++i) {
                                    attrValue = parser.getAttributeValue(i);
                                    if (attrValue.length() == 0 || !(attrName = parser.getAttributeName(i)).equalsIgnoreCase("ref")) continue;
                                    this.currentFits.setExtnum(attrValue);
                                }
                                break;
                            }
                            case 15: {
                                this.currentTableData = new SavotTableData();
                                if (parsingType != 2) break;
                                if (stats.getITablesLocal() > 1) {
                                    this._currentVOTable.getResources().removeItemAt(this._currentVOTable.getResources().getItemCount() - 1);
                                }
                                this._currentResource.getTables().addItem(this.currentTable);
                                this._currentVOTable.getResources().addItem(this._currentResource);
                                break;
                            }
                            case 16: {
                                String attrName;
                                String attrValue;
                                int i;
                                this.currentParam = new SavotParam();
                                int counter = parser.getAttributeCount();
                                if (counter == 0) break;
                                for (i = 0; i < counter; ++i) {
                                    attrValue = parser.getAttributeValue(i);
                                    if (attrValue.length() == 0) continue;
                                    attrName = parser.getAttributeName(i);
                                    if (attrName.equalsIgnoreCase("unit")) {
                                        this.currentParam.setUnit(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("datatype")) {
                                        this.currentParam.setDataType(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("precision")) {
                                        this.currentParam.setPrecision(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("width")) {
                                        this.currentParam.setWidth(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("ref")) {
                                        this.currentParam.setRef(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("name")) {
                                        this.currentParam.setName(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("ucd")) {
                                        this.currentParam.setUcd(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("utype")) {
                                        this.currentParam.setUtype(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("value")) {
                                        this.currentParam.setValue(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("xtype")) {
                                        this.currentParam.setXtype(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("arraysize")) {
                                        this.currentParam.setArraySize(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("xtype")) {
                                        this.currentParam.setXtype(attrValue);
                                        continue;
                                    }
                                    if (!attrName.equalsIgnoreCase("id")) continue;
                                    this.currentParam.setId(attrValue);
                                    this.idRefLinks.put(attrValue, this.currentParam);
                                }
                                break;
                            }
                            case 17: {
                                String attrName;
                                String attrValue;
                                int i;
                                this.currentParamRef = new SavotParamRef();
                                int counter = parser.getAttributeCount();
                                if (counter == 0) break;
                                for (i = 0; i < counter; ++i) {
                                    attrValue = parser.getAttributeValue(i);
                                    if (attrValue.length() == 0) continue;
                                    attrName = parser.getAttributeName(i);
                                    if (attrName.equalsIgnoreCase("ref")) {
                                        this.currentParamRef.setRef(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("ucd")) {
                                        this.currentParamRef.setUcd(attrValue);
                                        continue;
                                    }
                                    if (!attrName.equalsIgnoreCase("utype")) continue;
                                    this.currentParamRef.setUtype(attrValue);
                                }
                                break;
                            }
                            case 18: {
                                String attrName;
                                String attrValue;
                                int i;
                                this.currentLink = new SavotLink();
                                int counter = parser.getAttributeCount();
                                if (counter == 0) break;
                                for (i = 0; i < counter; ++i) {
                                    attrValue = parser.getAttributeValue(i);
                                    if (attrValue.length() == 0) continue;
                                    attrName = parser.getAttributeName(i);
                                    if (attrName.equalsIgnoreCase("content-role")) {
                                        this.currentLink.setContentRole(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("content-type")) {
                                        this.currentLink.setContentType(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("title")) {
                                        this.currentLink.setTitle(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("value")) {
                                        this.currentLink.setValue(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("href")) {
                                        this.currentLink.setHref(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("gref")) {
                                        this.currentLink.setGref(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("action")) {
                                        this.currentLink.setAction(attrValue);
                                        continue;
                                    }
                                    if (!attrName.equalsIgnoreCase("id")) continue;
                                    this.currentLink.setId(attrValue);
                                    this.idRefLinks.put(attrValue, this.currentLink);
                                }
                                break;
                            }
                            case 19: {
                                String attrName;
                                String attrValue;
                                int i;
                                this.currentInfo = new SavotInfo();
                                int counter = parser.getAttributeCount();
                                if (counter == 0) break;
                                for (i = 0; i < counter; ++i) {
                                    attrValue = parser.getAttributeValue(i);
                                    if (attrValue.length() == 0) continue;
                                    attrName = parser.getAttributeName(i);
                                    if (attrName.equalsIgnoreCase("name")) {
                                        this.currentInfo.setName(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("value")) {
                                        this.currentInfo.setValue(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("xtype")) {
                                        this.currentInfo.setXtype(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("unit")) {
                                        this.currentInfo.setUnit(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("ucd")) {
                                        this.currentInfo.setUcd(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("utype")) {
                                        this.currentInfo.setUtype(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("ref")) {
                                        this.currentInfo.setRef(attrValue);
                                        continue;
                                    }
                                    if (!attrName.equalsIgnoreCase("id")) continue;
                                    this.currentInfo.setId(attrValue);
                                    this.idRefLinks.put(attrValue, this.currentInfo);
                                }
                                break;
                            }
                            case 20: {
                                String attrName;
                                String attrValue;
                                int i;
                                this.currentMin = new SavotMin();
                                int counter = parser.getAttributeCount();
                                if (counter == 0) break;
                                for (i = 0; i < counter; ++i) {
                                    attrValue = parser.getAttributeValue(i);
                                    if (attrValue.length() == 0) continue;
                                    attrName = parser.getAttributeName(i);
                                    if (attrName.equalsIgnoreCase("value")) {
                                        this.currentMin.setValue(attrValue);
                                        continue;
                                    }
                                    if (!attrName.equalsIgnoreCase("inclusive")) continue;
                                    this.currentMin.setInclusive(attrValue);
                                }
                                break;
                            }
                            case 21: {
                                String attrName;
                                String attrValue;
                                int i;
                                this.currentMax = new SavotMax();
                                int counter = parser.getAttributeCount();
                                if (counter == 0) break;
                                for (i = 0; i < counter; ++i) {
                                    attrValue = parser.getAttributeValue(i);
                                    if (attrValue.length() == 0) continue;
                                    attrName = parser.getAttributeName(i);
                                    if (attrName.equalsIgnoreCase("value")) {
                                        this.currentMax.setValue(attrValue);
                                        continue;
                                    }
                                    if (!attrName.equalsIgnoreCase("inclusive")) continue;
                                    this.currentMax.setInclusive(attrValue);
                                }
                                break;
                            }
                            case 22: {
                                String attrName;
                                String attrValue;
                                int i;
                                if (this.includedOption > 0) {
                                    this.putOptionStack(this.currentOption);
                                    if (trace) {
                                        System.err.println("OPTION - included");
                                    }
                                } else if (trace) {
                                    System.err.println("OPTION - not included");
                                }
                                ++this.includedOption;
                                this.currentOption = new SavotOption();
                                int counter = parser.getAttributeCount();
                                if (counter == 0) break;
                                for (i = 0; i < counter; ++i) {
                                    attrValue = parser.getAttributeValue(i);
                                    if (attrValue.length() == 0) continue;
                                    attrName = parser.getAttributeName(i);
                                    if (attrName.equalsIgnoreCase("name")) {
                                        this.currentOption.setName(attrValue);
                                        continue;
                                    }
                                    if (!attrName.equalsIgnoreCase("value")) continue;
                                    this.currentOption.setValue(attrValue);
                                }
                                break;
                            }
                            case 23: {
                                String attrName;
                                String attrValue;
                                int i;
                                stats.iGroupsGlobalInc();
                                if (this.includedGroup > 0) {
                                    this.putGroupStack(this.currentGroup);
                                    if (trace) {
                                        System.err.println("GROUP - included");
                                    }
                                } else if (trace) {
                                    System.err.println("GROUP - not included");
                                }
                                ++this.includedGroup;
                                this.currentGroup = new SavotGroup();
                                int counter = parser.getAttributeCount();
                                if (counter == 0) break;
                                for (i = 0; i < counter; ++i) {
                                    attrValue = parser.getAttributeValue(i);
                                    if (attrValue.length() == 0) continue;
                                    attrName = parser.getAttributeName(i);
                                    if (attrName.equalsIgnoreCase("ref")) {
                                        this.currentGroup.setRef(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("name")) {
                                        this.currentGroup.setName(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("ucd")) {
                                        this.currentGroup.setUcd(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("utype")) {
                                        this.currentGroup.setUtype(attrValue);
                                        continue;
                                    }
                                    if (!attrName.equalsIgnoreCase("id")) continue;
                                    this.currentGroup.setId(attrValue);
                                    this.idRefLinks.put(attrValue, this.currentGroup);
                                }
                                break;
                            }
                            case 24: {
                                String attrName;
                                String attrValue;
                                int i;
                                this.currentCoosys = new SavotCoosys();
                                int counter = parser.getAttributeCount();
                                if (counter == 0) break;
                                for (i = 0; i < counter; ++i) {
                                    attrValue = parser.getAttributeValue(i);
                                    if (attrValue.length() == 0) continue;
                                    attrName = parser.getAttributeName(i);
                                    if (attrName.equalsIgnoreCase("equinox")) {
                                        this.currentCoosys.setEquinox(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("epoch")) {
                                        this.currentCoosys.setEpoch(attrValue);
                                        continue;
                                    }
                                    if (attrName.equalsIgnoreCase("SYSTEM")) {
                                        this.currentCoosys.setSystem(attrValue);
                                        continue;
                                    }
                                    if (!attrName.equalsIgnoreCase("id")) continue;
                                    this.currentCoosys.setId(attrValue);
                                    this.idRefLinks.put(attrValue, this.currentCoosys);
                                }
                                break;
                            }
                            case 25: {
                                this.currentDefinitions = new SavotDefinitions();
                                break;
                            }
                            default: {
                                System.err.println("VOTable markup error " + operation + " : " + tag + " at line " + parser.getLineNumber());
                            }
                        }
                        currentMarkup = tag;
                        break;
                    }
                    case 3: {
                        operation = "END_TAG";
                        name = parser.getName();
                        if (name == null) break;
                        if (trace) {
                            System.err.println("End ---> " + name);
                        }
                        tag = this.withNamespace(name) ? VOTableTag.parseTag(name.split(":")[1]) : VOTableTag.parseTag(name);
                        if (trace) {
                            System.err.println(tag + " end");
                        }
                        block34 : switch (1.$SwitchMap$cds$savot$common$VOTableTag[tag.ordinal()]) {
                            case 1: {
                                stats.iTDInc();
                                tdSet.addItem(currentTD == null ? emptyTD : currentTD);
                                break;
                            }
                            case 2: {
                                stats.iTRInc();
                                stats.iTDLocalReset();
                                tdSet.trim();
                                if (parsingType != 2) {
                                    this.currentTableData.getTRs().addItem(currentTR);
                                    currentTR = null;
                                } else {
                                    TRComplete = true;
                                    this._currentTR = currentTR;
                                }
                                if (!trace) break;
                                System.err.println("ADD row");
                                break;
                            }
                            case 3: {
                                switch (this.lastFather()) {
                                    case VOTABLE: {
                                        this._currentVOTable.setDescription(this.currentDescription);
                                        break;
                                    }
                                    case RESOURCE: {
                                        this._currentResource.setDescription(this.currentDescription);
                                        break;
                                    }
                                    case PARAM: {
                                        this.currentParam.setDescription(this.currentDescription);
                                        break;
                                    }
                                    case TABLE: {
                                        this.currentTable.setDescription(this.currentDescription);
                                        break;
                                    }
                                    case FIELD: {
                                        this.currentField.setDescription(this.currentDescription);
                                        break;
                                    }
                                    case GROUP: {
                                        this.currentGroup.setDescription(this.currentDescription);
                                        break;
                                    }
                                }
                                this.currentDescription = null;
                                break;
                            }
                            case 6: {
                                if (parsingType == 2) break;
                                this._currentResource.getTables().addItem(this.currentTable);
                                if (!trace) break;
                                System.err.println("TABLE " + this.currentTable.getName() + " added");
                                break;
                            }
                            case 7: {
                                if (trace) {
                                    System.err.println("FIELD from father = " + (Object)((Object)this.lastFather()));
                                }
                                if (this.lastFather() != VOTableTag.TABLE) break;
                                this.currentTable.getFields().addItem(this.currentField);
                                if (!trace) break;
                                System.err.println("FIELD from TABLE father = " + father);
                                break;
                            }
                            case 8: {
                                if (this.lastFather() != VOTableTag.GROUP) break;
                                this.currentGroup.getFieldsRef().addItem(this.currentFieldRef);
                                if (!trace) break;
                                System.err.println("FIELDRef from GROUP father = " + father);
                                break;
                            }
                            case 11: {
                                this.currentTable.setData(this.currentData);
                                break;
                            }
                            case 5: {
                                MarkupComment tmp;
                                if (this.includedResource > 1) {
                                    tmp = this._currentResource;
                                    this._currentResource = this.getResourceStack();
                                    this._currentResource.getResources().addItem(tmp);
                                } else {
                                    if (parsingType == 0) {
                                        this._currentVOTable.getResources().addItem(this._currentResource);
                                    }
                                    if (trace) {
                                        System.err.println(">>>>>>>> RESOURCE COMPLETED");
                                    }
                                    resourceComplete = true;
                                }
                                --this.includedResource;
                                break;
                            }
                            case 22: {
                                MarkupComment tmp;
                                if (this.includedOption > 1) {
                                    tmp = this.currentOption;
                                    this.currentOption = this.getOptionStack();
                                    this.currentOption.getOptions().addItem(tmp);
                                    --this.includedOption;
                                    break;
                                }
                                if (this.lastFather() != VOTableTag.VALUES) break;
                                this.currentValues.getOptions().addItem(this.currentOption);
                                if (trace) {
                                    System.err.println("OPTION from VALUES father = " + father);
                                }
                                --this.includedOption;
                                break;
                            }
                            case 23: {
                                MarkupComment tmp;
                                if (this.includedGroup > 1) {
                                    tmp = this.currentGroup;
                                    this.currentGroup = this.getGroupStack();
                                    this.currentGroup.getGroups().addItem(tmp);
                                    --this.includedGroup;
                                    break;
                                }
                                if (this.lastFather() == VOTableTag.TABLE) {
                                    this.currentTable.getGroups().addItem(this.currentGroup);
                                    if (trace) {
                                        System.err.println("GROUP from TABLE father = " + father);
                                    }
                                    --this.includedGroup;
                                    break;
                                }
                                if (this.lastFather() != VOTableTag.RESOURCE) break;
                                this._currentResource.getGroups().addItem(this.currentGroup);
                                if (trace) {
                                    System.err.println("GROUP from RESOURCE father = " + father);
                                }
                                --this.includedGroup;
                                break;
                            }
                            case 15: {
                                stats.iTRLocalReset();
                                this.currentTableData.getTRs().trim();
                                this.currentData.setTableData(this.currentTableData);
                                if (!trace) break;
                                System.err.println("TABLEDATA " + this.currentTable.getName() + " added");
                                break;
                            }
                            case 24: {
                                switch (this.lastFather()) {
                                    case DEFINITIONS: {
                                        this.currentDefinitions.getCoosys().addItem(this.currentCoosys);
                                        if (!trace) break block34;
                                        System.err.println("COOSYS from DEFINITIONS father = " + father);
                                        break;
                                    }
                                    case RESOURCE: {
                                        this._currentResource.getCoosys().addItem(this.currentCoosys);
                                        if (!trace) break block34;
                                        System.err.println("COOSYS from RESOURCE father = " + father);
                                        break;
                                    }
                                    case VOTABLE: {
                                        this._currentVOTable.getCoosys().addItem(this.currentCoosys);
                                        if (!trace) break block34;
                                        System.err.println("COOSYS from VOTABLE father = " + father);
                                        break;
                                    }
                                }
                                break;
                            }
                            case 16: {
                                switch (this.lastFather()) {
                                    case DEFINITIONS: {
                                        this.currentDefinitions.getParams().addItem(this.currentParam);
                                        if (!trace) break block34;
                                        System.err.println("PARAM from DEFINITIONS father = " + father);
                                        break;
                                    }
                                    case RESOURCE: {
                                        this._currentResource.getParams().addItem(this.currentParam);
                                        if (!trace) break block34;
                                        System.err.println("PARAM from RESOURCE father = " + father);
                                        break;
                                    }
                                    case TABLE: {
                                        this.currentTable.getParams().addItem(this.currentParam);
                                        if (!trace) break block34;
                                        System.err.println("PARAM from TABLE father = " + father);
                                        break;
                                    }
                                    case GROUP: {
                                        this.currentGroup.getParams().addItem(this.currentParam);
                                        if (!trace) break block34;
                                        System.err.println("PARAM from GROUP father = " + father);
                                        break;
                                    }
                                    case VOTABLE: {
                                        this._currentVOTable.getParams().addItem(this.currentParam);
                                        if (!trace) break block34;
                                        System.err.println("PARAM from VOTABLE father = " + father);
                                        break;
                                    }
                                }
                                break;
                            }
                            case 17: {
                                if (this.lastFather() != VOTableTag.GROUP) break;
                                this.currentGroup.getParamsRef().addItem(this.currentParamRef);
                                if (!trace) break;
                                System.err.println("PARAMRef from GROUP father = " + father);
                                break;
                            }
                            case 18: {
                                switch (this.lastFather()) {
                                    case RESOURCE: {
                                        this._currentResource.getLinks().addItem(this.currentLink);
                                        if (!trace) break block34;
                                        System.err.println("LINK from RESOURCE father = " + father);
                                        break;
                                    }
                                    case TABLE: {
                                        this.currentTable.getLinks().addItem(this.currentLink);
                                        if (!trace) break block34;
                                        System.err.println("LINK from TABLE father = " + father);
                                        break;
                                    }
                                    case FIELD: {
                                        this.currentField.getLinks().addItem(this.currentLink);
                                        if (!trace) break block34;
                                        System.err.println("LINK from FIELD father = " + father);
                                        break;
                                    }
                                    case PARAM: {
                                        this.currentParam.getLinks().addItem(this.currentLink);
                                        if (!trace) break block34;
                                        System.err.println("LINK from PARAM father = " + father);
                                        break;
                                    }
                                }
                                break;
                            }
                            case 9: {
                                switch (this.lastFather()) {
                                    case PARAM: {
                                        this.currentParam.setValues(this.currentValues);
                                        if (!trace) break block34;
                                        System.err.println("VALUES from PARAM father = " + father + " ID : " + this.currentValues.getId());
                                        break;
                                    }
                                    case FIELD: {
                                        this.currentField.setValues(this.currentValues);
                                        if (!trace) break block34;
                                        System.err.println("VALUES from FIELD father = " + father + " ID : " + this.currentValues.getId());
                                        break;
                                    }
                                }
                                break;
                            }
                            case 20: {
                                this.currentValues.setMin(this.currentMin);
                                break;
                            }
                            case 21: {
                                this.currentValues.setMax(this.currentMax);
                                break;
                            }
                            case 10: {
                                switch (this.lastFather()) {
                                    case BINARY: {
                                        this.currentBinary.setStream(this.currentStream);
                                        if (!trace) break block34;
                                        System.err.println("STREAM from BINARY father = " + father);
                                        break;
                                    }
                                    case BINARY2: {
                                        this.currentBinary2.setStream(this.currentStream);
                                        if (!trace) break block34;
                                        System.err.println("STREAM from BINARY2 father = " + father);
                                        break;
                                    }
                                    case FITS: {
                                        this.currentFits.setStream(this.currentStream);
                                        if (!trace) break block34;
                                        System.err.println("STREAM from FITS father = " + father);
                                        break;
                                    }
                                }
                                break;
                            }
                            case 12: {
                                this.currentData.setBinary(this.currentBinary);
                                break;
                            }
                            case 13: {
                                this.currentData.setBinary2(this.currentBinary2);
                                break;
                            }
                            case 14: {
                                this.currentData.setFits(this.currentFits);
                                break;
                            }
                            case 19: {
                                if (trace) {
                                    System.err.println("INFO father = " + father);
                                }
                                switch (this.lastFather()) {
                                    case VOTABLE: {
                                        if (this._currentVOTable.getResources() != null && this._currentVOTable.getResources().getItemCount() != 0) {
                                            this._currentVOTable.getInfosAtEnd().addItem(this.currentInfo);
                                        } else {
                                            this._currentVOTable.getInfos().addItem(this.currentInfo);
                                        }
                                        if (!trace) break block34;
                                        System.err.println("INFO from VOTABLE father = " + father);
                                        break;
                                    }
                                    case RESOURCE: {
                                        if (this._currentResource.getResources() != null && this._currentResource.getResources().getItemCount() != 0 || this._currentResource.getTables() != null && this._currentResource.getTables().getItemCount() != 0 || this._currentResource.getLinks() != null && this._currentResource.getLinks().getItemCount() != 0) {
                                            this._currentResource.getInfosAtEnd().addItem(this.currentInfo);
                                        } else {
                                            this._currentResource.getInfos().addItem(this.currentInfo);
                                        }
                                        if (!trace) break block34;
                                        System.err.println("INFO from RESOURCE father = " + father);
                                        break;
                                    }
                                    case TABLE: {
                                        this.currentTable.getInfosAtEnd().addItem(this.currentInfo);
                                        if (!trace) break block34;
                                        System.err.println("INFO from TABLE father = " + father);
                                        break;
                                    }
                                }
                                break;
                            }
                            case 25: {
                                this._currentVOTable.setDefinitions(this.currentDefinitions);
                                break;
                            }
                            case 4: {
                                break;
                            }
                            default: {
                                System.err.println("VOTable markup error " + operation + " : " + tag + " at line " + parser.getLineNumber());
                            }
                        }
                        currentMarkup = VOTableTag.UNDEFINED;
                        break;
                    }
                    case 4: {
                        String textValue;
                        operation = "TEXT";
                        if (parser.isWhitespace() || (textValue = parser.getText()).length() == 0) break;
                        if (trace) {
                            System.err.println(currentMarkup + " : " + textValue);
                        }
                        switch (1.$SwitchMap$cds$savot$common$VOTableTag[currentMarkup.ordinal()]) {
                            case 1: {
                                currentTD = new SavotTD(textValue);
                                break block1;
                            }
                            case 3: {
                                this.currentDescription = textValue;
                                break block1;
                            }
                            case 19: {
                                this.currentInfo.setContent(textValue);
                                break block1;
                            }
                            case 18: {
                                this.currentLink.setContent(textValue);
                                break block1;
                            }
                            case 24: {
                                this.currentCoosys.setContent(textValue);
                                break block1;
                            }
                            case 20: {
                                this.currentMin.setContent(textValue);
                                break block1;
                            }
                            case 21: {
                                this.currentMax.setContent(textValue);
                                break block1;
                            }
                            case 10: {
                                this.currentStream.setContent(textValue);
                                break block1;
                            }
                        }
                        break;
                    }
                    case 0: {
                        operation = "START_DOCUMENT";
                        if (!trace) break;
                        System.err.println("Document start.");
                        break;
                    }
                    default: {
                        operation = "UNDEFINED";
                        if (!trace) break;
                        System.err.println("Ignoring some other (legacy) event at line : " + parser.getLineNumber());
                    }
                }
                tag = null;
                eventType = parser.next();
                switch (eventType) {
                    case 2: {
                        operation = "START_TAG";
                        name = parser.getName();
                        if (trace) {
                            System.err.println("> FATHER, add : " + name);
                        }
                        tag = this.withNamespace(name) ? VOTableTag.parseTag(name.split(":")[1]) : VOTableTag.parseTag(name);
                        father.add((VOTableTag)tag);
                        break;
                    }
                    case 3: {
                        operation = "END_TAG";
                        name = parser.getName();
                        if (name != null) {
                            if (trace) {
                                System.err.println("> FATHER, remove : " + name);
                            }
                            father.remove(father.size() - 1);
                            break;
                        }
                        if (!trace) break;
                        System.err.println("> FATHER, case null");
                        break;
                    }
                    case 1: {
                        operation = "END_DOCUMENT";
                        if (trace) {
                            System.err.println("Document end reached!");
                        }
                        if (parsingType == 2) {
                            this._currentTR = null;
                        }
                        this.close();
                        break;
                    }
                }
                if (TRComplete && parsingType == 2) {
                    eventType = 1;
                    if (!trace) continue;
                    System.err.println(">>>>>>>>>>>>>>> ROWREAD case : TR end");
                    continue;
                }
                if (!resourceComplete || parsingType != 1) continue;
                eventType = 1;
                if (!trace) continue;
                System.err.println(">>>>>>>>>>>>>>> RESOURCEREAD case : RESOURCE end");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception " + operation + " - TAG (" + tag + ") : parse : " + e + " at line " + parser.getLineNumber(), e);
            throw e;
        }
    }

    private boolean withNamespace(String name) {
        return name.contains(":");
    }

    public SavotResource getNextResource() {
        this._currentResource = null;
        try {
            this.parse(1);
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "Exception getNextResource : ", ioe);
            this._currentResource = null;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception getNextResource : ", e);
            this._currentResource = null;
        }
        return this._currentResource;
    }

    public SavotTR getNextTR() {
        try {
            this.parse(2);
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "Exception getNextTR : ", ioe);
            this._currentTR = null;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception getNextTR : ", e);
            this._currentTR = null;
        }
        return this._currentTR;
    }

    public SavotVOTable getVOTable() {
        return this._currentVOTable;
    }

    public int getResourceCount() {
        return this.resourceCounter;
    }

    public int getTableCount() {
        return this.tableCounter;
    }

    public int getTRCount() {
        return this.rowCounter;
    }

    public int getDataCount() {
        return this.dataCounter;
    }

    public Map<String, Object> getIdRefLinks() {
        return this.idRefLinks;
    }

    public SavotResource getResourceFromRef(String ref) {
        return (SavotResource)this.idRefLinks.get(ref);
    }

    public SavotField getFieldFromRef(String ref) {
        return (SavotField)this.idRefLinks.get(ref);
    }

    public SavotFieldRef getFieldRefFromRef(String ref) {
        return (SavotFieldRef)this.idRefLinks.get(ref);
    }

    public SavotParam getParamFromRef(String ref) {
        return (SavotParam)this.idRefLinks.get(ref);
    }

    public SavotParamRef getParamRefFromRef(String ref) {
        return (SavotParamRef)this.idRefLinks.get(ref);
    }

    public SavotTable getTableFromRef(String ref) {
        return (SavotTable)this.idRefLinks.get(ref);
    }

    public SavotGroup getGroupFromRef(String ref) {
        return (SavotGroup)this.idRefLinks.get(ref);
    }

    public SavotInfo getInfoFromRef(String ref) {
        return (SavotInfo)this.idRefLinks.get(ref);
    }

    public SavotValues getValuesFromRef(String ref) {
        return (SavotValues)this.idRefLinks.get(ref);
    }

    public SavotLink getLinkFromRef(String ref) {
        return (SavotLink)this.idRefLinks.get(ref);
    }

    public SavotCoosys getCoosysFromRef(String ref) {
        return (SavotCoosys)this.idRefLinks.get(ref);
    }

    public SavotVOTable getAllResources() {
        return this._currentVOTable;
    }

    public void enableDebug(boolean debug) {
        this.debugMode = debug;
    }
}

